namespace Hive.Unity.Editor
{
    using System.Collections.Generic;

    internal class XmlOptional
    {
        HiveConfigXmlData data;

        internal List<string> unsupportedUaShareType;
        internal HiveConfigXML.AgreementDetermineBaseType agreementDetermineBase;
        internal int httpConnectTimeout;
        internal int httpReadTimeout;
        internal int maxGameLogSize;
        internal long analyticsSendLimit;
        internal long analyticsQueueLimit;
        internal long analyticsSendCycle;
        internal bool saveAnalyticsLogBeforeCrash;

        internal XmlOptional(HiveConfigXmlData data)
        {
            this.data = data;
            unsupportedUaShareType = data.Xml.unsupportedUAShareType;
            httpConnectTimeout = data.Xml.httpConnectTimeout;
            httpReadTimeout = data.Xml.httpReadTimeout;
            maxGameLogSize = data.Xml.maxGameLogSize;
            analyticsSendLimit = (long)data.Xml.analyticsSendLimit;
            analyticsQueueLimit = (long)data.Xml.analyticsQueueLimit;
            analyticsSendCycle = (long)data.Xml.analyticsSendCycle;
            saveAnalyticsLogBeforeCrash = data.Xml.saveAnalyticsLogBeforeCrash;
            agreementDetermineBase = data.Xml.agreementDetermineBase;
        }

        internal void Apply()
        {
            data.Xml.unsupportedUAShareType = unsupportedUaShareType;
            data.Xml.httpConnectTimeout = httpConnectTimeout;
            data.Xml.httpReadTimeout = httpReadTimeout;
            data.Xml.maxGameLogSize = maxGameLogSize;
            data.Xml.analyticsSendLimit = (uint)analyticsSendLimit;
            data.Xml.analyticsQueueLimit = (uint)analyticsQueueLimit;
            data.Xml.analyticsSendCycle = (uint)analyticsSendCycle;
            data.Xml.saveAnalyticsLogBeforeCrash = saveAnalyticsLogBeforeCrash;
            data.Xml.agreementDetermineBase = agreementDetermineBase;
        }
    }
}